/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.versions;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.SemanticVersion;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.UnknownServerVersionException;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class MinecraftVersion
extends SemanticVersion {
    public MinecraftVersion(int major, int minor, int patch) {
        super(major, minor, patch);
    }

    private MinecraftVersion(@Nonnull SemanticVersion version) {
        this(version.getMajorVersion(), version.getMinorVersion(), version.getPatchVersion());
    }

    @Nonnull
    public static MinecraftVersion of(@Nonnull Server server) throws UnknownServerVersionException {
        Validate.notNull(server, "Server should not be null!");
        String bukkitVersion = server.getBukkitVersion();
        try {
            String minecraftVersion = CommonPatterns.DASH.split(bukkitVersion)[0];
            return new MinecraftVersion(SemanticVersion.parse(minecraftVersion));
        }
        catch (Exception x) {
            throw new UnknownServerVersionException(bukkitVersion, x);
        }
    }

    @Nonnull
    public static MinecraftVersion get() throws UnknownServerVersionException {
        return MinecraftVersion.of(Bukkit.getServer());
    }

    public static boolean isMocked(@Nonnull Server server) {
        for (Class<?> clazz = server.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!clazz.getName().endsWith("mockbukkit.ServerMock")) continue;
            return true;
        }
        return false;
    }

    public static boolean isMocked() {
        return MinecraftVersion.isMocked(Bukkit.getServer());
    }

    @Override
    @Nonnull
    public String getAsString() {
        return "Minecraft " + super.getAsString();
    }
}

