/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.protection.modules;

import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.LandWorld;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class LandsProtectionModule
implements ProtectionModule {
    private LandsIntegration landsIntegration;
    private final Plugin lands;
    private final Plugin plugin;

    public LandsProtectionModule(@Nonnull Plugin lands, @Nonnull Plugin plugin) {
        this.lands = lands;
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.lands;
    }

    @Override
    public void load() {
        this.landsIntegration = LandsIntegration.of((Plugin)this.plugin);
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        LandWorld landWorld = this.landsIntegration.getWorld(l.getWorld());
        if (landWorld == null) {
            return true;
        }
        Area area = landWorld.getArea(l);
        return area == null || area.hasRoleFlag(p.getUniqueId(), this.convert(action));
    }

    @Nonnull
    private RoleFlag convert(@Nonnull Interaction protectableAction) {
        switch (protectableAction) {
            case PLACE_BLOCK: {
                return Flags.BLOCK_PLACE;
            }
            case BREAK_BLOCK: {
                return Flags.BLOCK_BREAK;
            }
            case INTERACT_BLOCK: {
                return Flags.INTERACT_CONTAINER;
            }
            case ATTACK_PLAYER: {
                return Flags.ATTACK_PLAYER;
            }
            case ATTACK_ENTITY: {
                return Flags.ATTACK_ANIMAL;
            }
        }
        return Flags.INTERACT_VILLAGER;
    }
}

