/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.Cookie;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Header;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Headers {
    private static final long serialVersionUID = 71310341388734766L;
    private List<Header> headers = new ArrayList<Header>();

    public Headers() {
    }

    public Headers(Collection<Entry> entries) {
        entries.forEach(e -> this.add(((Entry)e).name, ((Entry)e).value));
    }

    public void add(String name, String value) {
        this.add(name, () -> value);
    }

    public void add(String name, Supplier<String> value) {
        if (Objects.nonNull(name)) {
            this.headers.add(new Entry(name, value));
        }
    }

    public void replace(String name, String value) {
        this.remove(name);
        this.add(name, value);
    }

    public void remove(String name) {
        this.headers.removeIf(h -> this.isName((Header)h, name));
    }

    public int size() {
        return this.headers.stream().map(Header::getName).collect(Collectors.toSet()).size();
    }

    public List<String> get(String name) {
        return this.headers.stream().filter(h -> this.isName((Header)h, name)).map(Header::getValue).collect(Collectors.toList());
    }

    public void putAll(Headers header) {
        this.headers.addAll(header.headers);
    }

    public boolean containsKey(String name) {
        return this.headers.stream().anyMatch(h -> this.isName((Header)h, name));
    }

    public void clear() {
        this.headers.clear();
    }

    public String getFirst(String key) {
        return this.headers.stream().filter(h -> this.isName((Header)h, key)).findFirst().map(Header::getValue).orElse("");
    }

    public List<Header> all() {
        return new ArrayList<Header>(this.headers);
    }

    private boolean isName(Header h, String name) {
        return Util.nullToEmpty(name).equalsIgnoreCase(h.getName());
    }

    void remove(String key, String value) {
        List header = this.headers.stream().filter(h -> key.equalsIgnoreCase(h.getName()) && value.equalsIgnoreCase(h.getValue())).collect(Collectors.toList());
        this.headers.removeAll(header);
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(System.lineSeparator());
        this.headers.forEach(header -> sb.add(header.toString()));
        return sb.toString();
    }

    public void cookie(Cookie cookie) {
        this.headers.add(new Entry("cookie", cookie.toString()));
    }

    public void cookie(Collection<Cookie> cookies) {
        cookies.forEach(this::cookie);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers1 = (Headers)o;
        return Objects.equals(this.headers, headers1.headers);
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public void setBasicAuth(String username, String password) {
        this.replace("Authorization", Util.toBasicAuthValue(username, password));
    }

    public void accepts(String value) {
        this.add("Accept", value);
    }

    public void add(Map<String, String> headerMap) {
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public void replace(Map<String, String> headerMap) {
        if (headerMap != null) {
            headerMap.forEach(this::replace);
        }
    }

    static class Entry
    implements Header {
        private final String name;
        private final Supplier<String> value;

        public Entry(String name, String value) {
            this.name = name;
            this.value = () -> value;
        }

        public Entry(String name, Supplier<String> value) {
            this.name = name;
            this.value = value == null ? () -> null : value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.name, entry.name) && Objects.equals(this.value.get(), entry.value.get());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value.get());
        }

        public String toString() {
            return String.format("%s: %s", this.getName(), this.getValue());
        }
    }
}

