/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.handlers;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.LoopIterator;
import io.github.thebusybiscuit.slimefun4.utils.ColoredMaterial;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.GlassPane;

public class RainbowTickHandler
extends BlockTicker {
    private final LoopIterator<Material> iterator;
    private final boolean glassPanes;
    private Material material;

    public RainbowTickHandler(@Nonnull List<Material> materials) {
        Validate.noNullElements(materials, "A RainbowTicker cannot have a Material that is null!");
        if (materials.isEmpty()) {
            throw new IllegalArgumentException("A RainbowTicker must have at least one Material associated with it!");
        }
        this.glassPanes = this.containsGlassPanes(materials);
        this.iterator = new LoopIterator<Material>(materials);
        this.material = this.iterator.next();
    }

    public RainbowTickHandler(Material ... materials) {
        this(Arrays.asList(materials));
    }

    public RainbowTickHandler(@Nonnull ColoredMaterial material) {
        this(material.asList());
    }

    private boolean containsGlassPanes(@Nonnull List<Material> materials) {
        if (Slimefun.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return false;
        }
        for (Material type : materials) {
            if (!(type.createBlockData() instanceof GlassPane)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick(Block b, SlimefunItem item, Config data) {
        BlockData blockData;
        if (b.getType().isAir()) {
            return;
        }
        if (this.glassPanes && (blockData = b.getBlockData()) instanceof GlassPane) {
            GlassPane previousData = (GlassPane)blockData;
            BlockData block = this.material.createBlockData(bd -> {
                if (bd instanceof GlassPane) {
                    GlassPane nextData = (GlassPane)bd;
                    nextData.setWaterlogged(previousData.isWaterlogged());
                    for (BlockFace face : previousData.getAllowedFaces()) {
                        nextData.setFace(face, previousData.hasFace(face));
                    }
                }
            });
            b.setBlockData(block, false);
            return;
        }
        b.setType(this.material, false);
    }

    @Override
    public void uniqueTick() {
        this.material = this.iterator.next();
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }
}

