/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import javax.annotation.Nonnull;
import org.bukkit.inventory.ItemStack;

class ItemStackAndInteger {
    private ItemStack item;
    private ItemStackWrapper wrapper;
    private int number;

    ItemStackAndInteger(@Nonnull ItemStack item, int amount) {
        Validate.notNull(item, "Item cannot be null!");
        this.number = amount;
        this.item = item;
    }

    public int getInt() {
        return this.number;
    }

    @Nonnull
    public ItemStack getItem() {
        this.initializeItem();
        return this.item;
    }

    @Nonnull
    public ItemStackWrapper getItemStackWrapper() {
        if (this.wrapper == null) {
            this.wrapper = ItemStackWrapper.wrap(this.item);
        }
        return this.wrapper;
    }

    public void add(int amount) {
        this.number += amount;
    }

    private void initializeItem() {
        if (this.item instanceof ItemStackWrapper) {
            ItemStack copy = new ItemStack(this.item.getType(), this.item.getAmount());
            if (this.item.hasItemMeta()) {
                copy.setItemMeta(this.item.getItemMeta());
            }
            this.item = copy;
        }
    }
}

